<?php
/**
 *    Kalium WordPress Theme
 *
 *    Laborator.co
 *    www.laborator.co
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Direct access not allowed.
}

// Get Menu Type To Use
$main_menu_type = get_data( 'main_menu_type' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>

<?php
/**
 * Before header starts hooks
 *
 * @hooked woocommerce_demo_store - 10
 */
do_action( 'kalium_before_header' );

if ( apply_filters( 'kalium_show_header', true ) ) :

	// Theme Borders
	if ( get_data( 'theme_borders' ) ) :

		get_template_part( 'tpls/borders' );

	endif;

	// Mobile Menu
	include locate_template( 'tpls/menu-mobile.php' );

	// Top Menu
	if ( $main_menu_type == 'top-menu' || get_data( 'menu_top_force_include' ) ) {
		include locate_template( 'tpls/menu-top.php' );
	}

	// Sidebar Menu
	if ( $main_menu_type == 'sidebar-menu' || get_data( 'menu_sidebar_force_include' ) ) {
		include locate_template( 'tpls/menu-sidebar.php' );
	}

endif;
?>

<div class="wrapper" id="main-wrapper">

	<?php
	// Kalium Start Wrapper
	do_action( 'kalium_wrapper_start' );

	// Show Header
	if ( apply_filters( 'kalium_show_header', true ) ):

		// Main Header
		get_template_part( 'tpls/header-main' );

	endif;
	?>
