<?php
global $post, $product, $woocommerce_wishlist_options;

$elements = $woocommerce_wishlist_options['dataToShow']['enabled'];
$wishlist = $post;
$current_user_id = get_current_user_id();

$visibility = get_post_meta($wishlist->ID, 'visibility', true);

do_action( 'woocommerce_wishlist_before_wishlist' );
?>

<div class="woocommerce-wishlist-header">
	<h3 class="woocommerce-wishlist-header-title"><?php echo $wishlist->post_title ?></h3>
	<?php 
	if($wishlist->post_author != $current_user_id && $visibility == 'private') {
		echo __('This wishlist is set to private.', 'woocommerce-wishlist');
		echo '</div>';
		return false;
	} elseif($wishlist->post_author == $current_user_id) {

	?>
	<div class="woocommerce-wishlist-header-actions">
		<a href="#" data-id="<?php echo $wishlist->ID ?>" class="woocommerce-wishlist-edit"><?php echo __('Edit Wishlist', 'woocommerce-wishlist') ?></a>
		<a href="#" data-id="<?php echo $wishlist->ID ?>" class="woocommerce-wishlist-delete"><?php echo __('Delete Wishlist', 'woocommerce-wishlist') ?></a>
	</div>
	<?php } ?>
</div>

<?php

do_action( 'woocommerce_wishlist_before_products' );

$products = get_post_meta($wishlist->ID, 'products', true);

if(!$products || empty($products)) {
	echo __('No products added to this wishlist so far.', 'woocommerce-wishlist');
	return false;
}

foreach ($products as $product) {
	
	$product = wc_get_product($product['product_id']);

	wc_get_template( 'woocommerce-wishlist-single-item.php', array(), '', plugin_dir_path(__FILE__));

	wp_reset_postdata();
}

do_action( 'woocommerce_wishlist_after_products' );

if($woocommerce_wishlist_options['shareEnabled'] == "1" && $visibility !== "private") {

	echo '<div class="woocommerce-wishlist-share">';

		echo '<div class="woocommerce-wishlist-share-title">'. __('Share this Wishlist ...', 'woocommerce-wishlist') . '</div>';

		$title = $woocommerce_wishlist_options['shareTitle'];
		$url = get_permalink($woocommerce_wishlist_options['wishlistPage']) . '?wishlist=' . $wishlist->ID;

		if($woocommerce_wishlist_options['sharePrint'] == "1") {
			echo '<a href="javascript:window.print();" class="woocommerce-wishlist-share-print"><i class="fa fa-print"></i></a>';
		}

		if($woocommerce_wishlist_options['shareFacebook'] == "1") {
			$data = array(
				'title' => $title,
				'u' => $url,
			);
			$share_url = '//www.facebook.com/sharer.php?' . http_build_query($data);
			echo '<a href="' . $share_url . '" class="woocommerce-wishlist-share-facebook" target="_blank"><i class="fa fa-facebook"></i></a>';
		}

		if($woocommerce_wishlist_options['shareTwitter'] == "1") {
			$data = array('url' => $url);
			$share_url = '//twitter.com/share?' . http_build_query($data);
			echo '<a href="' . $share_url . '" class="woocommerce-wishlist-share-twitter" target="_blank"><i class="fa fa-twitter"></i></a>';
		}

		if($woocommerce_wishlist_options['sharePinterest'] == "1") {
			$data = array('url' => $url);
			$share_url = '//pinterest.com/pin/create/?' . http_build_query($data);
			echo '<a href="' . $share_url . '" class="woocommerce-wishlist-share-pinterest" target="_blank"><i class="fa fa-pinterest"></i></a>';
		}

		if($woocommerce_wishlist_options['shareEmail'] == "1") {
			$data = array(
				'subject' => $title,
				'body' => $url,
			);
			$share_url = 'mailto:?' . http_build_query($data);
			echo '<a href="' . $share_url . '" class="woocommerce-wishlist-share-envelope" target="_blank"><i class="fa fa-envelope"></i></a>';
		}


	echo '</div>';
}

do_action( 'woocommerce_wishlist_after_wishlist' );
?>