<?php

    /**
     * For full documentation, please visit: http://docs.reduxframework.com/
     * For a more extensive sample-config file, you may look at:
     * https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php
     */

    if ( ! class_exists( 'Redux' ) ) {
        return;
    }

    // This is your option name where all the Redux data is stored.
    $opt_name = "woocommerce_wishlist_options";

    /**
     * ---> SET ARGUMENTS
     * All the possible arguments for Redux.
     * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
     * */

    $theme = wp_get_theme(); // For use with some settings. Not necessary.

    $args = array(
        'opt_name' => 'woocommerce_wishlist_options',
        'use_cdn' => TRUE,
        'dev_mode' => FALSE,
        'display_name' => 'WooCommerce Wishlist',
        'display_version' => '1.1.0',
        'page_title' => 'WooCommerce Wishlist',
        'update_notice' => TRUE,
        'intro_text' => '',
        'footer_text' => '&copy; '.date('Y').' weLaunch',
        'admin_bar' => TRUE,
        'menu_type' => 'submenu',
        'menu_title' => 'Settings',
        'allow_sub_menu' => TRUE,
        'page_parent' => 'edit.php?post_type=wishlist',
        // 'page_parent_post_type' => 'stores',
        'customizer' => FALSE,
        'default_mark' => '*',
        'hints' => array(
            'icon_position' => 'right',
            'icon_color' => 'lightgray',
            'icon_size' => 'normal',
            'tip_style' => array(
                'color' => 'light',
            ),
            'tip_position' => array(
                'my' => 'top left',
                'at' => 'bottom right',
            ),
            'tip_effect' => array(
                'show' => array(
                    'duration' => '500',
                    'event' => 'mouseover',
                ),
                'hide' => array(
                    'duration' => '500',
                    'event' => 'mouseleave unfocus',
                ),
            ),
        ),
        'output' => TRUE,
        'output_tag' => TRUE,
        'settings_api' => TRUE,
        'cdn_check_time' => '1440',
        'compiler' => TRUE,
        'page_permissions' => 'manage_options',
        'save_defaults' => TRUE,
        'show_import_export' => TRUE,
        'database' => 'options',
        'transient_time' => '3600',
        'network_sites' => TRUE,
    );

    Redux::setArgs( $opt_name, $args );

    /*
     * ---> END ARGUMENTS
     */

    /*
     * ---> START HELP TABS
     */

    $tabs = array(
        array(
            'id'      => 'help-tab',
            'title'   => __('Information', 'woocommerce-wishlist' ),
            'content' => __('<p>Need support? Please use the comment function on codecanyon.</p>', 'woocommerce-wishlist' )
        ),
    );
    Redux::setHelpTab( $opt_name, $tabs );

    // Set the help sidebar
    // $content = __('<p>This is the sidebar content, HTML is allowed.</p>', 'woocommerce-wishlist' );
    // Redux::setHelpSidebar( $opt_name, $content );
    /*
     * <--- END HELP TABS
     */
    $atts = wc_get_attribute_taxonomies();

    $enabled = array(
            'im' => __('Image', 'woocommerce-wishlist'),
            'ti' => __('Title', 'woocommerce-wishlist'),
            're' => __('Reviews', 'woocommerce-wishlist'),
            'pr' => __('Price', 'woocommerce-wishlist'),
            'st' => __('Stock', 'woocommerce-wishlist'),
            'sk' => __('SKU', 'woocommerce-wishlist'),
            'tg' => __('Tags', 'woocommerce-wishlist'),
            'ct' => __('Categories', 'woocommerce-wishlist'),
            'sd' => __('Short Description', 'woocommerce-wishlist'),
            'ca' => __('Add to Cart', 'woocommerce-wishlist'),
    );

    $enabled = array_merge($enabled);
    $dataToShow = array(
        'enabled' => $enabled,
        'disabled' => array(
            'de' => __('Description', 'woocommerce-wishlist'),
            'at' => __('Attributes', 'woocommerce-wishlist'),
            'rm' => __('Read More', 'woocommerce-wishlist'),
        )
    );

    /*
     *
     * ---> START SECTIONS
     *
     */

    Redux::setSection( $opt_name, array(
        'title'  => __('Wishlist', 'woocommerce-wishlist' ),
        'id'     => 'general',
        'desc'   => __('Need support? Please use the comment function on codecanyon.', 'woocommerce-wishlist' ),
        'icon'   => 'el el-home',
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('General', 'woocommerce-wishlist' ),
        // 'desc'       => __('', 'woocommerce-wishlist' ),
        'id'         => 'general-settings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'enable',
                'type'     => 'checkbox',
                'title'    => __('Enable', 'woocommerce-wishlist' ),
                'subtitle' => __('Enable Wishlist.', 'woocommerce-wishlist' ),
                'default'  => '1',
            ),
            array(
                'id'       => 'cookieLifetime',
                'type'     => 'spinner',
                'title'    => __( 'Cookie Lifetime.', 'woocommerce-wishlist' ),
                'subtitle'    => __( 'Minutes before the Cookie expires.', 'woocommerce-wishlist' ),
                'min'      => '1',
                'step'     => '1',
                'max'      => '999999999',
                'default'  => '44640',
            ),
            array(
                'id'       => 'wishlistPage',
                'type'     => 'select',
                'title'    => __('Set your Wishlist Page', 'woocommerce-wishlist'),
                'subtitle' => __('Make sure you add the shortcode [woocommerce_wishlist].', 'woocommerce-wishlist'),
                'data'     => 'pages',
                'required' => array('enable', 'equals', '1'),
            ),
            array(
                'id'       => 'wishlistLoginPage',
                'type'     => 'select',
                'title'    => __('Set your Wishlist Login Page', 'woocommerce-wishlist'),
                'subtitle' => __('If empty it takes wp-admin default URL.', 'woocommerce-wishlist'),
                'data'     => 'pages',
                'required' => array('enable', 'equals', '1'),
            ),
            array(
                'id'       => 'wishlistSearchEnable',
                'type'     => 'checkbox',
                'title'    => __('Enable Wishlist Search', 'woocommerce-wishlist' ),
                'subtitle' => __('Enable to search for public Wishlists.', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('enable', 'equals', '1'),
            ),
            array(
                'id'       => 'wishlistSearchPage',
                'type'     => 'select',
                'title'    => __('Set your Wishlist Search Page', 'woocommerce-wishlist'),
                'subtitle' => __('Make sure you add the shortcode [woocommerce_wishlist_search].', 'woocommerce-wishlist'),
                'data'     => 'pages',
                'required' => array('wishlistSearchEnable', 'equals', '1'),
            ),
            array(
                'id'       => 'guestWishlists',
                'type'     => 'checkbox',
                'title'    => __('Enable Guest Wishlists', 'woocommerce-wishlist' ),
                'subtitle' => __('Not logged in users can create wishlists. They will be saved in a cookie, but they can not create own wishlists.', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('enable', 'equals', '1'),
            ),
            array(
                'id'       => 'guestWishlistRemoveLoginText',
                'type'     => 'checkbox',
                'title'    => __('Guest Wishlist Remove Sidebar & Login Text', 'woocommerce-wishlist' ),
                'subtitle' => __('Removes the please login text & the sidebar for guest users.', 'woocommerce-wishlist' ),
                'default'  => '0',
                'required' => array('guestWishlists', 'equals', '1'),
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('Button', 'woocommerce-wishlist' ),
        // 'desc'       => __('', 'woocommerce-wishlist' ),
        'id'         => 'buttonSettings',
        'subsection' => true,
        'fields'     => array(
            array(
                'id'       => 'shopLoopButtonEnable',
                'type'     => 'checkbox',
                'title'    => __('Enable Shop Loop Button', 'woocommerce-wishlist' ),
                'default'  => '1',
            ),
            array(
                'id'       => 'shopLoopButtonPosition',
                'type'     => 'select',
                'title'    => __('Shop Loop Position', 'woocommerce-wishlist'),
                'subtitle' => __('Specify the positon of the wishlist button in the shop loop.', 'woocommerce-wishlist'),
                'default'  => 'woocommerce_after_shop_loop_item',
                'options'  => array( 
                    'none' => __('None (Custom Integration)', 'woocommerce-wishlist'),
                    'woocommerce_before_shop_loop_item' => __('before_shop_loop_item', 'woocommerce-wishlist'),
                    'woocommerce_before_shop_loop_item_title' => __('before_shop_loop_item_title', 'woocommerce-wishlist'),
                    'woocommerce_shop_loop_item_title' => __('shop_loop_item_title', 'woocommerce-wishlist'),
                    'woocommerce_after_shop_loop_item_title' => __('after_shop_loop_item_title', 'woocommerce-wishlist'),
                    'woocommerce_after_shop_loop_item' => __('after_shop_loop_item', 'woocommerce-wishlist'),
                ),
                'required' => array('shopLoopButtonEnable', 'equals', '1'),
            ),
            array(
                'id'       => 'shopLoopButtonPriority',
                'type'     => 'spinner',
                'title'    => __( 'Hook Priority', 'woocommerce-wishlist' ),
                'min'      => '1',
                'step'     => '1',
                'max'      => '999',
                'default'  => '10',
                'required' => array('shopLoopButtonEnable', 'equals', '1'),
            ),
            array(
                'id'       => 'singleProductButtonEnable',
                'type'     => 'checkbox',
                'title'    => __('Enable Product Page Button', 'woocommerce-wishlist' ),
                'default'  => '1',
            ),
            array(
                'id'       => 'singleProductButtonPosition',
                'type'     => 'select',
                'title'    => __('Single Product Page Position', 'woocommerce-wishlist'),
                'subtitle' => __('Specify the positon of the wishlist button on the single product page.', 'woocommerce-wishlist'),
                'default'  => 'woocommerce_product_meta_start',
                'options'  => array( 
                    'woocommerce_before_single_product' => __('Before Single Product', 'woocommerce-wishlist'),
                    'woocommerce_before_single_product_summary' => __('Before Single Product Summary', 'woocommerce-wishlist'),
                    'woocommerce_single_product_summary' => __('In Single Product Summary', 'woocommerce-wishlist'),
                    'woocommerce_product_meta_start' => __('Before Meta Information', 'woocommerce-wishlist'),
                    'woocommerce_product_meta_end' => __('After Meta Information', 'woocommerce-wishlist'),
                    'woocommerce_after_single_product_summary' => __('After Single Product Summary', 'woocommerce-wishlist'),
                    'woocommerce_after_single_product' => __('After Single Product', 'woocommerce-wishlist'),
                    'woocommerce_after_main_content' => __('After Main Product', 'woocommerce-wishlist'),
                ),
                'required' => array('singleProductButtonEnable', 'equals', '1'),
            ),
            array(
                'id'       => 'singleProductButtonPriority',
                'type'     => 'spinner',
                'title'    => __( 'Hook Priority', 'woocommerce-wishlist' ),
                'min'      => '1',
                'step'     => '1',
                'max'      => '999',
                'default'  => '10',
                'required' => array('singleProductButtonEnable', 'equals', '1'),
            ),
        )
    ));

    Redux::setSection( $opt_name, array(
        'title'      => __('Styling', 'woocommerce-wishlist' ),
        // 'desc'       => __('', 'woocommerce-wishlist' ),
        'id'         => 'stylingSettings',
        'subsection' => true,
        'fields'     => array(
            array(
               'id' => 'section-modal-styles',
               'type' => 'section',
               'title' => __('Modal Styles', 'woocommerce-wishlist'),
               'subtitle' => __('Styles for the wishlist modal.', 'woocommerce-wishlist'),
               'indent' => false,
            ),
            array(
                'id'             => 'modalPadding',
                'type'           => 'spacing',
                'mode'           => 'padding',
                'units'          => array('px'),
                'units_extended' => 'false',
                'title'          => __('Modal Padding', 'woocommerce-wishlist'),
                'subtitle'       => __('Choose the padding for the modal.', 'woocommerce-wishlist'),
                'default'            => array(
                    'padding-top'     => '20px', 
                    'padding-right'   => '20px', 
                    'padding-bottom'  => '20px', 
                    'padding-left'    => '20px',
                    'units'          => 'px', 
                ),
            ),
            array(
                'id'        => 'modalTextColor',
                'type'      => 'color',
                'title'    => __('Modal Text Color', 'woocommerce-wishlist'), 
                'subtitle' => __('Text Color of the Modal', 'woocommerce-wishlist'),            
                'default'   => '#333333',  
            
            ),
            array(
                'id'        => 'modalBackgroundColor',
                'type'      => 'color',
                'title'    => __('Modal Background Color', 'woocommerce-wishlist'), 
                'subtitle' => __('Background Color of the Modal', 'woocommerce-wishlist'),            
                'default'   => '#FFFFFF',            
            ),
            array(
               'id' => 'section-backdrop-styles',
               'type' => 'section',
               'title' => __('Backdrop Styles', 'woocommerce-wishlist'),
               'subtitle' => __('Styles for the modal backdrop.', 'woocommerce-wishlist'),
               'indent' => false,
            ),
            array(
                'id'        => 'backdropBackgroundColor',
                'type'      => 'color_rgba',
                'title'    => __('Background Color', 'woocommerce-wishlist'),
                'default'   => array(
                    'color'     => '#000000',
                    'alpha'     => 0.9
                ),
                'options'       => array(
                    'show_input'                => true,
                    'show_initial'              => true,
                    'show_alpha'                => true,
                    'show_palette'              => true,
                    'show_palette_only'         => false,
                    'show_selection_palette'    => true,
                    'max_palette_size'          => 10,
                    'allow_empty'               => true,
                    'clickout_fires_change'     => false,
                    'choose_text'               => 'Choose',
                    'cancel_text'               => 'Cancel',
                    'show_buttons'              => true,
                    'use_extended_classes'      => true,
                    'palette'                   => null,  // show default
                    'input_text'                => __('Select Color', 'woocommerce-wishlist')
                ), 
            ),
        )
    ) );

    Redux::setSection( $opt_name, array(
        'title'      => __('Data to Show', 'woocommerce-wishlist' ),
        // 'desc'       => __('Custom stylesheet / javascript.', 'woocommerce-wishlist' ),
        'id'         => 'data',
        'subsection' => true,
        'fields'     =>  array(
            array(
                'id'      => 'dataToShow',
                'type'    => 'sorter',
                'title'   => 'Data fields to Show',
                'subtitle'    => __('Reorder, enable or disable data fields.', 'woocommerce-wishlist' ),
                'options' => $dataToShow
            ),
            array(
                'id'       => 'shareEnabled',
                'type'     => 'checkbox',
                'title'    => __('Show Share Buttons', 'woocommerce-wishlist' ),
                'default'  => '1',
            ),
            array(
                'id'       => 'shareTitle',
                'type'     => 'text',
                'title'    => __('Share Title', 'woocommerce-wishlist'),
                'default'  => __('My Wishlist on YOUR_SITE', 'woocommerce-wishlist'),
                'required' => array('shareEnabled','equals','1'),
            ),
            array(
                'id'       => 'sharePrint',
                'type'     => 'checkbox',
                'title'    => __('Show Print', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('shareEnabled','equals','1'),
            ),
            array(
                'id'       => 'shareFacebook',
                'type'     => 'checkbox',
                'title'    => __('Show Facebook Share', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('shareEnabled','equals','1'),
            ),
            array(
                'id'       => 'shareTwitter',
                'type'     => 'checkbox',
                'title'    => __('Show Twitter Share', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('shareEnabled','equals','1'),
            ),
            array(
                'id'       => 'sharePinterest',
                'type'     => 'checkbox',
                'title'    => __('Show Pinterest Share', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('shareEnabled','equals','1'),
            ),
            array(
                'id'       => 'shareEmail',
                'type'     => 'checkbox',
                'title'    => __('Show Email Share', 'woocommerce-wishlist' ),
                'default'  => '1',
                'required' => array('shareEnabled','equals','1'),
            ),
        )
    ) );

    /*
     * <--- END SECTIONS
     */
