<?php

namespace NF_FU_VENDOR;

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
class Google_Service_DriveActivity_Move extends \NF_FU_VENDOR\Google_Collection
{
    protected $collection_key = 'removedParents';
    protected $addedParentsType = 'Google_Service_DriveActivity_TargetReference';
    protected $addedParentsDataType = 'array';
    protected $removedParentsType = 'Google_Service_DriveActivity_TargetReference';
    protected $removedParentsDataType = 'array';
    /**
     * @param Google_Service_DriveActivity_TargetReference
     */
    public function setAddedParents($addedParents)
    {
        $this->addedParents = $addedParents;
    }
    /**
     * @return Google_Service_DriveActivity_TargetReference
     */
    public function getAddedParents()
    {
        return $this->addedParents;
    }
    /**
     * @param Google_Service_DriveActivity_TargetReference
     */
    public function setRemovedParents($removedParents)
    {
        $this->removedParents = $removedParents;
    }
    /**
     * @return Google_Service_DriveActivity_TargetReference
     */
    public function getRemovedParents()
    {
        return $this->removedParents;
    }
}
