<?php

namespace NF_FU_VENDOR;

// This file was auto-generated from sdk-root/src/data/wafv2/2019-07-29/api-2.json
return ['version' => '2.0', 'metadata' => ['apiVersion' => '2019-07-29', 'endpointPrefix' => 'wafv2', 'jsonVersion' => '1.1', 'protocol' => 'json', 'serviceAbbreviation' => 'WAFV2', 'serviceFullName' => 'AWS WAFV2', 'serviceId' => 'WAFV2', 'signatureVersion' => 'v4', 'targetPrefix' => 'AWSWAF_20190729', 'uid' => 'wafv2-2019-07-29'], 'operations' => ['AssociateWebACL' => ['name' => 'AssociateWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'AssociateWebACLRequest'], 'output' => ['shape' => 'AssociateWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFUnavailableEntityException']]], 'CheckCapacity' => ['name' => 'CheckCapacity', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'CheckCapacityRequest'], 'output' => ['shape' => 'CheckCapacityResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFInvalidResourceException'], ['shape' => 'WAFUnavailableEntityException']]], 'CreateIPSet' => ['name' => 'CreateIPSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'CreateIPSetRequest'], 'output' => ['shape' => 'CreateIPSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'CreateRegexPatternSet' => ['name' => 'CreateRegexPatternSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'CreateRegexPatternSetRequest'], 'output' => ['shape' => 'CreateRegexPatternSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'CreateRuleGroup' => ['name' => 'CreateRuleGroup', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'CreateRuleGroupRequest'], 'output' => ['shape' => 'CreateRuleGroupResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFUnavailableEntityException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'CreateWebACL' => ['name' => 'CreateWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'CreateWebACLRequest'], 'output' => ['shape' => 'CreateWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFInvalidResourceException'], ['shape' => 'WAFUnavailableEntityException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'DeleteIPSet' => ['name' => 'DeleteIPSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DeleteIPSetRequest'], 'output' => ['shape' => 'DeleteIPSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'DeleteLoggingConfiguration' => ['name' => 'DeleteLoggingConfiguration', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DeleteLoggingConfigurationRequest'], 'output' => ['shape' => 'DeleteLoggingConfigurationResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFOptimisticLockException']]], 'DeleteRegexPatternSet' => ['name' => 'DeleteRegexPatternSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DeleteRegexPatternSetRequest'], 'output' => ['shape' => 'DeleteRegexPatternSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'DeleteRuleGroup' => ['name' => 'DeleteRuleGroup', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DeleteRuleGroupRequest'], 'output' => ['shape' => 'DeleteRuleGroupResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'DeleteWebACL' => ['name' => 'DeleteWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DeleteWebACLRequest'], 'output' => ['shape' => 'DeleteWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFAssociatedItemException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'DescribeManagedRuleGroup' => ['name' => 'DescribeManagedRuleGroup', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DescribeManagedRuleGroupRequest'], 'output' => ['shape' => 'DescribeManagedRuleGroupResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFInvalidResourceException'], ['shape' => 'WAFNonexistentItemException']]], 'DisassociateWebACL' => ['name' => 'DisassociateWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'DisassociateWebACLRequest'], 'output' => ['shape' => 'DisassociateWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException']]], 'GetIPSet' => ['name' => 'GetIPSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetIPSetRequest'], 'output' => ['shape' => 'GetIPSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException']]], 'GetLoggingConfiguration' => ['name' => 'GetLoggingConfiguration', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetLoggingConfigurationRequest'], 'output' => ['shape' => 'GetLoggingConfigurationResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFNonexistentItemException']]], 'GetRateBasedStatementManagedKeys' => ['name' => 'GetRateBasedStatementManagedKeys', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetRateBasedStatementManagedKeysRequest'], 'output' => ['shape' => 'GetRateBasedStatementManagedKeysResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException']]], 'GetRegexPatternSet' => ['name' => 'GetRegexPatternSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetRegexPatternSetRequest'], 'output' => ['shape' => 'GetRegexPatternSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException']]], 'GetRuleGroup' => ['name' => 'GetRuleGroup', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetRuleGroupRequest'], 'output' => ['shape' => 'GetRuleGroupResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException']]], 'GetSampledRequests' => ['name' => 'GetSampledRequests', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetSampledRequestsRequest'], 'output' => ['shape' => 'GetSampledRequestsResponse'], 'errors' => [['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'GetWebACL' => ['name' => 'GetWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetWebACLRequest'], 'output' => ['shape' => 'GetWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException']]], 'GetWebACLForResource' => ['name' => 'GetWebACLForResource', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'GetWebACLForResourceRequest'], 'output' => ['shape' => 'GetWebACLForResourceResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFUnavailableEntityException']]], 'ListAvailableManagedRuleGroups' => ['name' => 'ListAvailableManagedRuleGroups', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListAvailableManagedRuleGroupsRequest'], 'output' => ['shape' => 'ListAvailableManagedRuleGroupsResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'ListIPSets' => ['name' => 'ListIPSets', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListIPSetsRequest'], 'output' => ['shape' => 'ListIPSetsResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'ListLoggingConfigurations' => ['name' => 'ListLoggingConfigurations', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListLoggingConfigurationsRequest'], 'output' => ['shape' => 'ListLoggingConfigurationsResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'ListRegexPatternSets' => ['name' => 'ListRegexPatternSets', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListRegexPatternSetsRequest'], 'output' => ['shape' => 'ListRegexPatternSetsResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'ListResourcesForWebACL' => ['name' => 'ListResourcesForWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListResourcesForWebACLRequest'], 'output' => ['shape' => 'ListResourcesForWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFInvalidParameterException']]], 'ListRuleGroups' => ['name' => 'ListRuleGroups', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListRuleGroupsRequest'], 'output' => ['shape' => 'ListRuleGroupsResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'ListTagsForResource' => ['name' => 'ListTagsForResource', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListTagsForResourceRequest'], 'output' => ['shape' => 'ListTagsForResourceResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'ListWebACLs' => ['name' => 'ListWebACLs', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'ListWebACLsRequest'], 'output' => ['shape' => 'ListWebACLsResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'PutLoggingConfiguration' => ['name' => 'PutLoggingConfiguration', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'PutLoggingConfigurationRequest'], 'output' => ['shape' => 'PutLoggingConfigurationResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFServiceLinkedRoleErrorException'], ['shape' => 'WAFInvalidParameterException']]], 'TagResource' => ['name' => 'TagResource', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'TagResourceRequest'], 'output' => ['shape' => 'TagResourceResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'UntagResource' => ['name' => 'UntagResource', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'UntagResourceRequest'], 'output' => ['shape' => 'UntagResourceResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFTagOperationException'], ['shape' => 'WAFTagOperationInternalErrorException']]], 'UpdateIPSet' => ['name' => 'UpdateIPSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'UpdateIPSetRequest'], 'output' => ['shape' => 'UpdateIPSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException']]], 'UpdateRegexPatternSet' => ['name' => 'UpdateRegexPatternSet', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'UpdateRegexPatternSetRequest'], 'output' => ['shape' => 'UpdateRegexPatternSetResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException']]], 'UpdateRuleGroup' => ['name' => 'UpdateRuleGroup', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'UpdateRuleGroupRequest'], 'output' => ['shape' => 'UpdateRuleGroupResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFUnavailableEntityException']]], 'UpdateWebACL' => ['name' => 'UpdateWebACL', 'http' => ['method' => 'POST', 'requestUri' => '/'], 'input' => ['shape' => 'UpdateWebACLRequest'], 'output' => ['shape' => 'UpdateWebACLResponse'], 'errors' => [['shape' => 'WAFInternalErrorException'], ['shape' => 'WAFInvalidParameterException'], ['shape' => 'WAFNonexistentItemException'], ['shape' => 'WAFDuplicateItemException'], ['shape' => 'WAFOptimisticLockException'], ['shape' => 'WAFLimitsExceededException'], ['shape' => 'WAFInvalidResourceException'], ['shape' => 'WAFUnavailableEntityException']]]], 'shapes' => ['Action' => ['type' => 'string'], 'AllQueryArguments' => ['type' => 'structure', 'members' => []], 'AllowAction' => ['type' => 'structure', 'members' => []], 'AndStatement' => ['type' => 'structure', 'required' => ['Statements'], 'members' => ['Statements' => ['shape' => 'Statements']]], 'AssociateWebACLRequest' => ['type' => 'structure', 'required' => ['WebACLArn', 'ResourceArn'], 'members' => ['WebACLArn' => ['shape' => 'ResourceArn'], 'ResourceArn' => ['shape' => 'ResourceArn']]], 'AssociateWebACLResponse' => ['type' => 'structure', 'members' => []], 'BlockAction' => ['type' => 'structure', 'members' => []], 'Body' => ['type' => 'structure', 'members' => []], 'Boolean' => ['type' => 'boolean'], 'ByteMatchStatement' => ['type' => 'structure', 'required' => ['SearchString', 'FieldToMatch', 'TextTransformations', 'PositionalConstraint'], 'members' => ['SearchString' => ['shape' => 'SearchString'], 'FieldToMatch' => ['shape' => 'FieldToMatch'], 'TextTransformations' => ['shape' => 'TextTransformations'], 'PositionalConstraint' => ['shape' => 'PositionalConstraint']]], 'CapacityUnit' => ['type' => 'long', 'min' => 1], 'CheckCapacityRequest' => ['type' => 'structure', 'required' => ['Scope', 'Rules'], 'members' => ['Scope' => ['shape' => 'Scope'], 'Rules' => ['shape' => 'Rules']]], 'CheckCapacityResponse' => ['type' => 'structure', 'members' => ['Capacity' => ['shape' => 'ConsumedCapacity']]], 'ComparisonOperator' => ['type' => 'string', 'enum' => ['EQ', 'NE', 'LE', 'LT', 'GE', 'GT']], 'ConsumedCapacity' => ['type' => 'long', 'min' => 0], 'CountAction' => ['type' => 'structure', 'members' => []], 'Country' => ['type' => 'string'], 'CountryCode' => ['type' => 'string', 'enum' => ['AF', 'AX', 'AL', 'DZ', 'AS', 'AD', 'AO', 'AI', 'AQ', 'AG', 'AR', 'AM', 'AW', 'AU', 'AT', 'AZ', 'BS', 'BH', 'BD', 'BB', 'BY', 'BE', 'BZ', 'BJ', 'BM', 'BT', 'BO', 'BQ', 'BA', 'BW', 'BV', 'BR', 'IO', 'BN', 'BG', 'BF', 'BI', 'KH', 'CM', 'CA', 'CV', 'KY', 'CF', 'TD', 'CL', 'CN', 'CX', 'CC', 'CO', 'KM', 'CG', 'CD', 'CK', 'CR', 'CI', 'HR', 'CU', 'CW', 'CY', 'CZ', 'DK', 'DJ', 'DM', 'DO', 'EC', 'EG', 'SV', 'GQ', 'ER', 'EE', 'ET', 'FK', 'FO', 'FJ', 'FI', 'FR', 'GF', 'PF', 'TF', 'GA', 'GM', 'GE', 'DE', 'GH', 'GI', 'GR', 'GL', 'GD', 'GP', 'GU', 'GT', 'GG', 'GN', 'GW', 'GY', 'HT', 'HM', 'VA', 'HN', 'HK', 'HU', 'IS', 'IN', 'ID', 'IR', 'IQ', 'IE', 'IM', 'IL', 'IT', 'JM', 'JP', 'JE', 'JO', 'KZ', 'KE', 'KI', 'KP', 'KR', 'KW', 'KG', 'LA', 'LV', 'LB', 'LS', 'LR', 'LY', 'LI', 'LT', 'LU', 'MO', 'MK', 'MG', 'MW', 'MY', 'MV', 'ML', 'MT', 'MH', 'MQ', 'MR', 'MU', 'YT', 'MX', 'FM', 'MD', 'MC', 'MN', 'ME', 'MS', 'MA', 'MZ', 'MM', 'NA', 'NR', 'NP', 'NL', 'NC', 'NZ', 'NI', 'NE', 'NG', 'NU', 'NF', 'MP', 'NO', 'OM', 'PK', 'PW', 'PS', 'PA', 'PG', 'PY', 'PE', 'PH', 'PN', 'PL', 'PT', 'PR', 'QA', 'RE', 'RO', 'RU', 'RW', 'BL', 'SH', 'KN', 'LC', 'MF', 'PM', 'VC', 'WS', 'SM', 'ST', 'SA', 'SN', 'RS', 'SC', 'SL', 'SG', 'SX', 'SK', 'SI', 'SB', 'SO', 'ZA', 'GS', 'SS', 'ES', 'LK', 'SD', 'SR', 'SJ', 'SZ', 'SE', 'CH', 'SY', 'TW', 'TJ', 'TZ', 'TH', 'TL', 'TG', 'TK', 'TO', 'TT', 'TN', 'TR', 'TM', 'TC', 'TV', 'UG', 'UA', 'AE', 'GB', 'US', 'UM', 'UY', 'UZ', 'VU', 'VE', 'VN', 'VG', 'VI', 'WF', 'EH', 'YE', 'ZM', 'ZW']], 'CountryCodes' => ['type' => 'list', 'member' => ['shape' => 'CountryCode'], 'min' => 1], 'CreateIPSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'IPAddressVersion', 'Addresses'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Description' => ['shape' => 'EntityDescription'], 'IPAddressVersion' => ['shape' => 'IPAddressVersion'], 'Addresses' => ['shape' => 'IPAddresses'], 'Tags' => ['shape' => 'TagList']]], 'CreateIPSetResponse' => ['type' => 'structure', 'members' => ['Summary' => ['shape' => 'IPSetSummary']]], 'CreateRegexPatternSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'RegularExpressionList'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Description' => ['shape' => 'EntityDescription'], 'RegularExpressionList' => ['shape' => 'RegularExpressionList'], 'Tags' => ['shape' => 'TagList']]], 'CreateRegexPatternSetResponse' => ['type' => 'structure', 'members' => ['Summary' => ['shape' => 'RegexPatternSetSummary']]], 'CreateRuleGroupRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Capacity', 'VisibilityConfig'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Capacity' => ['shape' => 'CapacityUnit'], 'Description' => ['shape' => 'EntityDescription'], 'Rules' => ['shape' => 'Rules'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig'], 'Tags' => ['shape' => 'TagList']]], 'CreateRuleGroupResponse' => ['type' => 'structure', 'members' => ['Summary' => ['shape' => 'RuleGroupSummary']]], 'CreateWebACLRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'DefaultAction', 'VisibilityConfig'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'DefaultAction' => ['shape' => 'DefaultAction'], 'Description' => ['shape' => 'EntityDescription'], 'Rules' => ['shape' => 'Rules'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig'], 'Tags' => ['shape' => 'TagList']]], 'CreateWebACLResponse' => ['type' => 'structure', 'members' => ['Summary' => ['shape' => 'WebACLSummary']]], 'DefaultAction' => ['type' => 'structure', 'members' => ['Block' => ['shape' => 'BlockAction'], 'Allow' => ['shape' => 'AllowAction']]], 'DeleteIPSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'LockToken' => ['shape' => 'LockToken']]], 'DeleteIPSetResponse' => ['type' => 'structure', 'members' => []], 'DeleteLoggingConfigurationRequest' => ['type' => 'structure', 'required' => ['ResourceArn'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn']]], 'DeleteLoggingConfigurationResponse' => ['type' => 'structure', 'members' => []], 'DeleteRegexPatternSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'LockToken' => ['shape' => 'LockToken']]], 'DeleteRegexPatternSetResponse' => ['type' => 'structure', 'members' => []], 'DeleteRuleGroupRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'LockToken' => ['shape' => 'LockToken']]], 'DeleteRuleGroupResponse' => ['type' => 'structure', 'members' => []], 'DeleteWebACLRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'LockToken' => ['shape' => 'LockToken']]], 'DeleteWebACLResponse' => ['type' => 'structure', 'members' => []], 'DescribeManagedRuleGroupRequest' => ['type' => 'structure', 'required' => ['VendorName', 'Name', 'Scope'], 'members' => ['VendorName' => ['shape' => 'VendorName'], 'Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope']]], 'DescribeManagedRuleGroupResponse' => ['type' => 'structure', 'members' => ['Capacity' => ['shape' => 'CapacityUnit'], 'Rules' => ['shape' => 'RuleSummaries']]], 'DisassociateWebACLRequest' => ['type' => 'structure', 'required' => ['ResourceArn'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn']]], 'DisassociateWebACLResponse' => ['type' => 'structure', 'members' => []], 'EntityDescription' => ['type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '^[\\w+=:#@/\\-,\\.][\\w+=:#@/\\-,\\.\\s]+[\\w+=:#@/\\-,\\.]$'], 'EntityId' => ['type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$'], 'EntityName' => ['type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^[\\w\\-]+$'], 'ErrorMessage' => ['type' => 'string'], 'ErrorReason' => ['type' => 'string'], 'ExcludedRule' => ['type' => 'structure', 'required' => ['Name'], 'members' => ['Name' => ['shape' => 'EntityName']]], 'ExcludedRules' => ['type' => 'list', 'member' => ['shape' => 'ExcludedRule']], 'FieldToMatch' => ['type' => 'structure', 'members' => ['SingleHeader' => ['shape' => 'SingleHeader'], 'SingleQueryArgument' => ['shape' => 'SingleQueryArgument'], 'AllQueryArguments' => ['shape' => 'AllQueryArguments'], 'UriPath' => ['shape' => 'UriPath'], 'QueryString' => ['shape' => 'QueryString'], 'Body' => ['shape' => 'Body'], 'Method' => ['shape' => 'Method']]], 'FieldToMatchData' => ['type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '.*\\S.*'], 'GeoMatchStatement' => ['type' => 'structure', 'members' => ['CountryCodes' => ['shape' => 'CountryCodes']]], 'GetIPSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId']]], 'GetIPSetResponse' => ['type' => 'structure', 'members' => ['IPSet' => ['shape' => 'IPSet'], 'LockToken' => ['shape' => 'LockToken']]], 'GetLoggingConfigurationRequest' => ['type' => 'structure', 'required' => ['ResourceArn'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn']]], 'GetLoggingConfigurationResponse' => ['type' => 'structure', 'members' => ['LoggingConfiguration' => ['shape' => 'LoggingConfiguration']]], 'GetRateBasedStatementManagedKeysRequest' => ['type' => 'structure', 'required' => ['Scope', 'WebACLName', 'WebACLId', 'RuleName'], 'members' => ['Scope' => ['shape' => 'Scope'], 'WebACLName' => ['shape' => 'EntityName'], 'WebACLId' => ['shape' => 'EntityId'], 'RuleName' => ['shape' => 'EntityName']]], 'GetRateBasedStatementManagedKeysResponse' => ['type' => 'structure', 'members' => ['ManagedKeysIPV4' => ['shape' => 'RateBasedStatementManagedKeysIPSet'], 'ManagedKeysIPV6' => ['shape' => 'RateBasedStatementManagedKeysIPSet']]], 'GetRegexPatternSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId']]], 'GetRegexPatternSetResponse' => ['type' => 'structure', 'members' => ['RegexPatternSet' => ['shape' => 'RegexPatternSet'], 'LockToken' => ['shape' => 'LockToken']]], 'GetRuleGroupRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId']]], 'GetRuleGroupResponse' => ['type' => 'structure', 'members' => ['RuleGroup' => ['shape' => 'RuleGroup'], 'LockToken' => ['shape' => 'LockToken']]], 'GetSampledRequestsRequest' => ['type' => 'structure', 'required' => ['WebAclArn', 'RuleMetricName', 'Scope', 'TimeWindow', 'MaxItems'], 'members' => ['WebAclArn' => ['shape' => 'ResourceArn'], 'RuleMetricName' => ['shape' => 'MetricName'], 'Scope' => ['shape' => 'Scope'], 'TimeWindow' => ['shape' => 'TimeWindow'], 'MaxItems' => ['shape' => 'ListMaxItems']]], 'GetSampledRequestsResponse' => ['type' => 'structure', 'members' => ['SampledRequests' => ['shape' => 'SampledHTTPRequests'], 'PopulationSize' => ['shape' => 'PopulationSize'], 'TimeWindow' => ['shape' => 'TimeWindow']]], 'GetWebACLForResourceRequest' => ['type' => 'structure', 'required' => ['ResourceArn'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn']]], 'GetWebACLForResourceResponse' => ['type' => 'structure', 'members' => ['WebACL' => ['shape' => 'WebACL']]], 'GetWebACLRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId']]], 'GetWebACLResponse' => ['type' => 'structure', 'members' => ['WebACL' => ['shape' => 'WebACL'], 'LockToken' => ['shape' => 'LockToken']]], 'HTTPHeader' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'HeaderName'], 'Value' => ['shape' => 'HeaderValue']]], 'HTTPHeaders' => ['type' => 'list', 'member' => ['shape' => 'HTTPHeader']], 'HTTPMethod' => ['type' => 'string'], 'HTTPRequest' => ['type' => 'structure', 'members' => ['ClientIP' => ['shape' => 'IPString'], 'Country' => ['shape' => 'Country'], 'URI' => ['shape' => 'URIString'], 'Method' => ['shape' => 'HTTPMethod'], 'HTTPVersion' => ['shape' => 'HTTPVersion'], 'Headers' => ['shape' => 'HTTPHeaders']]], 'HTTPVersion' => ['type' => 'string'], 'HeaderName' => ['type' => 'string'], 'HeaderValue' => ['type' => 'string'], 'IPAddress' => ['type' => 'string', 'max' => 50, 'min' => 1, 'pattern' => '.*\\S.*'], 'IPAddressVersion' => ['type' => 'string', 'enum' => ['IPV4', 'IPV6']], 'IPAddresses' => ['type' => 'list', 'member' => ['shape' => 'IPAddress']], 'IPSet' => ['type' => 'structure', 'required' => ['Name', 'Id', 'ARN', 'IPAddressVersion', 'Addresses'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'ARN' => ['shape' => 'ResourceArn'], 'Description' => ['shape' => 'EntityDescription'], 'IPAddressVersion' => ['shape' => 'IPAddressVersion'], 'Addresses' => ['shape' => 'IPAddresses']]], 'IPSetReferenceStatement' => ['type' => 'structure', 'required' => ['ARN'], 'members' => ['ARN' => ['shape' => 'ResourceArn']]], 'IPSetSummaries' => ['type' => 'list', 'member' => ['shape' => 'IPSetSummary']], 'IPSetSummary' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'LockToken' => ['shape' => 'LockToken'], 'ARN' => ['shape' => 'ResourceArn']]], 'IPString' => ['type' => 'string'], 'ListAvailableManagedRuleGroupsRequest' => ['type' => 'structure', 'required' => ['Scope'], 'members' => ['Scope' => ['shape' => 'Scope'], 'NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit']]], 'ListAvailableManagedRuleGroupsResponse' => ['type' => 'structure', 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'ManagedRuleGroups' => ['shape' => 'ManagedRuleGroupSummaries']]], 'ListIPSetsRequest' => ['type' => 'structure', 'required' => ['Scope'], 'members' => ['Scope' => ['shape' => 'Scope'], 'NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit']]], 'ListIPSetsResponse' => ['type' => 'structure', 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'IPSets' => ['shape' => 'IPSetSummaries']]], 'ListLoggingConfigurationsRequest' => ['type' => 'structure', 'members' => ['Scope' => ['shape' => 'Scope'], 'NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit']]], 'ListLoggingConfigurationsResponse' => ['type' => 'structure', 'members' => ['LoggingConfigurations' => ['shape' => 'LoggingConfigurations'], 'NextMarker' => ['shape' => 'NextMarker']]], 'ListMaxItems' => ['type' => 'long', 'max' => 500, 'min' => 1], 'ListRegexPatternSetsRequest' => ['type' => 'structure', 'required' => ['Scope'], 'members' => ['Scope' => ['shape' => 'Scope'], 'NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit']]], 'ListRegexPatternSetsResponse' => ['type' => 'structure', 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'RegexPatternSets' => ['shape' => 'RegexPatternSetSummaries']]], 'ListResourcesForWebACLRequest' => ['type' => 'structure', 'required' => ['WebACLArn'], 'members' => ['WebACLArn' => ['shape' => 'ResourceArn'], 'ResourceType' => ['shape' => 'ResourceType']]], 'ListResourcesForWebACLResponse' => ['type' => 'structure', 'members' => ['ResourceArns' => ['shape' => 'ResourceArns']]], 'ListRuleGroupsRequest' => ['type' => 'structure', 'required' => ['Scope'], 'members' => ['Scope' => ['shape' => 'Scope'], 'NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit']]], 'ListRuleGroupsResponse' => ['type' => 'structure', 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'RuleGroups' => ['shape' => 'RuleGroupSummaries']]], 'ListTagsForResourceRequest' => ['type' => 'structure', 'required' => ['ResourceARN'], 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit'], 'ResourceARN' => ['shape' => 'ResourceArn']]], 'ListTagsForResourceResponse' => ['type' => 'structure', 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'TagInfoForResource' => ['shape' => 'TagInfoForResource']]], 'ListWebACLsRequest' => ['type' => 'structure', 'required' => ['Scope'], 'members' => ['Scope' => ['shape' => 'Scope'], 'NextMarker' => ['shape' => 'NextMarker'], 'Limit' => ['shape' => 'PaginationLimit']]], 'ListWebACLsResponse' => ['type' => 'structure', 'members' => ['NextMarker' => ['shape' => 'NextMarker'], 'WebACLs' => ['shape' => 'WebACLSummaries']]], 'LockToken' => ['type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '^[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$'], 'LogDestinationConfigs' => ['type' => 'list', 'member' => ['shape' => 'ResourceArn'], 'max' => 100, 'min' => 1], 'LoggingConfiguration' => ['type' => 'structure', 'required' => ['ResourceArn', 'LogDestinationConfigs'], 'members' => ['ResourceArn' => ['shape' => 'ResourceArn'], 'LogDestinationConfigs' => ['shape' => 'LogDestinationConfigs'], 'RedactedFields' => ['shape' => 'RedactedFields']]], 'LoggingConfigurations' => ['type' => 'list', 'member' => ['shape' => 'LoggingConfiguration']], 'ManagedRuleGroupStatement' => ['type' => 'structure', 'required' => ['VendorName', 'Name'], 'members' => ['VendorName' => ['shape' => 'VendorName'], 'Name' => ['shape' => 'EntityName'], 'ExcludedRules' => ['shape' => 'ExcludedRules']]], 'ManagedRuleGroupSummaries' => ['type' => 'list', 'member' => ['shape' => 'ManagedRuleGroupSummary']], 'ManagedRuleGroupSummary' => ['type' => 'structure', 'members' => ['VendorName' => ['shape' => 'VendorName'], 'Name' => ['shape' => 'EntityName'], 'Description' => ['shape' => 'EntityDescription']]], 'Method' => ['type' => 'structure', 'members' => []], 'MetricName' => ['type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[\\w#:\\.\\-/]+$'], 'NextMarker' => ['type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '.*\\S.*'], 'NoneAction' => ['type' => 'structure', 'members' => []], 'NotStatement' => ['type' => 'structure', 'required' => ['Statement'], 'members' => ['Statement' => ['shape' => 'Statement']]], 'OrStatement' => ['type' => 'structure', 'required' => ['Statements'], 'members' => ['Statements' => ['shape' => 'Statements']]], 'OverrideAction' => ['type' => 'structure', 'members' => ['Count' => ['shape' => 'CountAction'], 'None' => ['shape' => 'NoneAction']]], 'PaginationLimit' => ['type' => 'integer', 'max' => 100, 'min' => 1], 'ParameterExceptionField' => ['type' => 'string', 'enum' => ['WEB_ACL', 'RULE_GROUP', 'REGEX_PATTERN_SET', 'IP_SET', 'MANAGED_RULE_SET', 'RULE', 'EXCLUDED_RULE', 'STATEMENT', 'BYTE_MATCH_STATEMENT', 'SQLI_MATCH_STATEMENT', 'XSS_MATCH_STATEMENT', 'SIZE_CONSTRAINT_STATEMENT', 'GEO_MATCH_STATEMENT', 'RATE_BASED_STATEMENT', 'RULE_GROUP_REFERENCE_STATEMENT', 'REGEX_PATTERN_REFERENCE_STATEMENT', 'IP_SET_REFERENCE_STATEMENT', 'MANAGED_RULE_SET_STATEMENT', 'AND_STATEMENT', 'OR_STATEMENT', 'NOT_STATEMENT', 'IP_ADDRESS', 'IP_ADDRESS_VERSION', 'FIELD_TO_MATCH', 'TEXT_TRANSFORMATION', 'SINGLE_QUERY_ARGUMENT', 'SINGLE_HEADER', 'DEFAULT_ACTION', 'RULE_ACTION', 'ENTITY_LIMIT', 'OVERRIDE_ACTION', 'SCOPE_VALUE', 'RESOURCE_ARN', 'RESOURCE_TYPE', 'TAGS', 'TAG_KEYS']], 'ParameterExceptionParameter' => ['type' => 'string', 'min' => 1], 'PopulationSize' => ['type' => 'long'], 'PositionalConstraint' => ['type' => 'string', 'enum' => ['EXACTLY', 'STARTS_WITH', 'ENDS_WITH', 'CONTAINS', 'CONTAINS_WORD']], 'PutLoggingConfigurationRequest' => ['type' => 'structure', 'required' => ['LoggingConfiguration'], 'members' => ['LoggingConfiguration' => ['shape' => 'LoggingConfiguration']]], 'PutLoggingConfigurationResponse' => ['type' => 'structure', 'members' => ['LoggingConfiguration' => ['shape' => 'LoggingConfiguration']]], 'QueryString' => ['type' => 'structure', 'members' => []], 'RateBasedStatement' => ['type' => 'structure', 'required' => ['Limit', 'AggregateKeyType'], 'members' => ['Limit' => ['shape' => 'RateLimit'], 'AggregateKeyType' => ['shape' => 'RateBasedStatementAggregateKeyType'], 'ScopeDownStatement' => ['shape' => 'Statement']]], 'RateBasedStatementAggregateKeyType' => ['type' => 'string', 'enum' => ['IP']], 'RateBasedStatementManagedKeysIPSet' => ['type' => 'structure', 'members' => ['IPAddressVersion' => ['shape' => 'IPAddressVersion'], 'Addresses' => ['shape' => 'IPAddresses']]], 'RateLimit' => ['type' => 'long', 'max' => 2000000000, 'min' => 100], 'RedactedFields' => ['type' => 'list', 'member' => ['shape' => 'FieldToMatch'], 'max' => 100], 'Regex' => ['type' => 'structure', 'members' => ['RegexString' => ['shape' => 'RegexPatternString']]], 'RegexPatternSet' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'ARN' => ['shape' => 'ResourceArn'], 'Description' => ['shape' => 'EntityDescription'], 'RegularExpressionList' => ['shape' => 'RegularExpressionList']]], 'RegexPatternSetReferenceStatement' => ['type' => 'structure', 'required' => ['ARN', 'FieldToMatch', 'TextTransformations'], 'members' => ['ARN' => ['shape' => 'ResourceArn'], 'FieldToMatch' => ['shape' => 'FieldToMatch'], 'TextTransformations' => ['shape' => 'TextTransformations']]], 'RegexPatternSetSummaries' => ['type' => 'list', 'member' => ['shape' => 'RegexPatternSetSummary']], 'RegexPatternSetSummary' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'LockToken' => ['shape' => 'LockToken'], 'ARN' => ['shape' => 'ResourceArn']]], 'RegexPatternString' => ['type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => '.*'], 'RegularExpressionList' => ['type' => 'list', 'member' => ['shape' => 'Regex'], 'min' => 1], 'ResourceArn' => ['type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => '.*\\S.*'], 'ResourceArns' => ['type' => 'list', 'member' => ['shape' => 'ResourceArn']], 'ResourceType' => ['type' => 'string', 'enum' => ['APPLICATION_LOAD_BALANCER', 'API_GATEWAY']], 'Rule' => ['type' => 'structure', 'required' => ['Name', 'Priority', 'Statement', 'VisibilityConfig'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Priority' => ['shape' => 'RulePriority'], 'Statement' => ['shape' => 'Statement'], 'Action' => ['shape' => 'RuleAction'], 'OverrideAction' => ['shape' => 'OverrideAction'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig']]], 'RuleAction' => ['type' => 'structure', 'members' => ['Block' => ['shape' => 'BlockAction'], 'Allow' => ['shape' => 'AllowAction'], 'Count' => ['shape' => 'CountAction']]], 'RuleGroup' => ['type' => 'structure', 'required' => ['Name', 'Id', 'Capacity', 'ARN', 'VisibilityConfig'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'Capacity' => ['shape' => 'CapacityUnit'], 'ARN' => ['shape' => 'ResourceArn'], 'Description' => ['shape' => 'EntityDescription'], 'Rules' => ['shape' => 'Rules'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig']]], 'RuleGroupReferenceStatement' => ['type' => 'structure', 'required' => ['ARN'], 'members' => ['ARN' => ['shape' => 'ResourceArn'], 'ExcludedRules' => ['shape' => 'ExcludedRules']]], 'RuleGroupSummaries' => ['type' => 'list', 'member' => ['shape' => 'RuleGroupSummary']], 'RuleGroupSummary' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'LockToken' => ['shape' => 'LockToken'], 'ARN' => ['shape' => 'ResourceArn']]], 'RulePriority' => ['type' => 'integer', 'min' => 0], 'RuleSummaries' => ['type' => 'list', 'member' => ['shape' => 'RuleSummary']], 'RuleSummary' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'EntityName'], 'Action' => ['shape' => 'RuleAction']]], 'Rules' => ['type' => 'list', 'member' => ['shape' => 'Rule']], 'SampleWeight' => ['type' => 'long', 'min' => 0], 'SampledHTTPRequest' => ['type' => 'structure', 'required' => ['Request', 'Weight'], 'members' => ['Request' => ['shape' => 'HTTPRequest'], 'Weight' => ['shape' => 'SampleWeight'], 'Timestamp' => ['shape' => 'Timestamp'], 'Action' => ['shape' => 'Action'], 'RuleNameWithinRuleGroup' => ['shape' => 'EntityName']]], 'SampledHTTPRequests' => ['type' => 'list', 'member' => ['shape' => 'SampledHTTPRequest']], 'Scope' => ['type' => 'string', 'enum' => ['CLOUDFRONT', 'REGIONAL']], 'SearchString' => ['type' => 'blob'], 'SingleHeader' => ['type' => 'structure', 'required' => ['Name'], 'members' => ['Name' => ['shape' => 'FieldToMatchData']]], 'SingleQueryArgument' => ['type' => 'structure', 'required' => ['Name'], 'members' => ['Name' => ['shape' => 'FieldToMatchData']]], 'Size' => ['type' => 'long', 'max' => 21474836480, 'min' => 0], 'SizeConstraintStatement' => ['type' => 'structure', 'required' => ['FieldToMatch', 'ComparisonOperator', 'Size', 'TextTransformations'], 'members' => ['FieldToMatch' => ['shape' => 'FieldToMatch'], 'ComparisonOperator' => ['shape' => 'ComparisonOperator'], 'Size' => ['shape' => 'Size'], 'TextTransformations' => ['shape' => 'TextTransformations']]], 'SqliMatchStatement' => ['type' => 'structure', 'required' => ['FieldToMatch', 'TextTransformations'], 'members' => ['FieldToMatch' => ['shape' => 'FieldToMatch'], 'TextTransformations' => ['shape' => 'TextTransformations']]], 'Statement' => ['type' => 'structure', 'members' => ['ByteMatchStatement' => ['shape' => 'ByteMatchStatement'], 'SqliMatchStatement' => ['shape' => 'SqliMatchStatement'], 'XssMatchStatement' => ['shape' => 'XssMatchStatement'], 'SizeConstraintStatement' => ['shape' => 'SizeConstraintStatement'], 'GeoMatchStatement' => ['shape' => 'GeoMatchStatement'], 'RuleGroupReferenceStatement' => ['shape' => 'RuleGroupReferenceStatement'], 'IPSetReferenceStatement' => ['shape' => 'IPSetReferenceStatement'], 'RegexPatternSetReferenceStatement' => ['shape' => 'RegexPatternSetReferenceStatement'], 'RateBasedStatement' => ['shape' => 'RateBasedStatement'], 'AndStatement' => ['shape' => 'AndStatement'], 'OrStatement' => ['shape' => 'OrStatement'], 'NotStatement' => ['shape' => 'NotStatement'], 'ManagedRuleGroupStatement' => ['shape' => 'ManagedRuleGroupStatement']]], 'Statements' => ['type' => 'list', 'member' => ['shape' => 'Statement']], 'Tag' => ['type' => 'structure', 'required' => ['Key', 'Value'], 'members' => ['Key' => ['shape' => 'TagKey'], 'Value' => ['shape' => 'TagValue']]], 'TagInfoForResource' => ['type' => 'structure', 'members' => ['ResourceARN' => ['shape' => 'ResourceArn'], 'TagList' => ['shape' => 'TagList']]], 'TagKey' => ['type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '.*\\S.*'], 'TagKeyList' => ['type' => 'list', 'member' => ['shape' => 'TagKey'], 'min' => 1], 'TagList' => ['type' => 'list', 'member' => ['shape' => 'Tag'], 'min' => 1], 'TagResourceRequest' => ['type' => 'structure', 'required' => ['ResourceARN', 'Tags'], 'members' => ['ResourceARN' => ['shape' => 'ResourceArn'], 'Tags' => ['shape' => 'TagList']]], 'TagResourceResponse' => ['type' => 'structure', 'members' => []], 'TagValue' => ['type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '.*'], 'TextTransformation' => ['type' => 'structure', 'required' => ['Priority', 'Type'], 'members' => ['Priority' => ['shape' => 'TextTransformationPriority'], 'Type' => ['shape' => 'TextTransformationType']]], 'TextTransformationPriority' => ['type' => 'integer', 'min' => 0], 'TextTransformationType' => ['type' => 'string', 'enum' => ['NONE', 'COMPRESS_WHITE_SPACE', 'HTML_ENTITY_DECODE', 'LOWERCASE', 'CMD_LINE', 'URL_DECODE']], 'TextTransformations' => ['type' => 'list', 'member' => ['shape' => 'TextTransformation'], 'min' => 1], 'TimeWindow' => ['type' => 'structure', 'required' => ['StartTime', 'EndTime'], 'members' => ['StartTime' => ['shape' => 'Timestamp'], 'EndTime' => ['shape' => 'Timestamp']]], 'Timestamp' => ['type' => 'timestamp'], 'URIString' => ['type' => 'string'], 'UntagResourceRequest' => ['type' => 'structure', 'required' => ['ResourceARN', 'TagKeys'], 'members' => ['ResourceARN' => ['shape' => 'ResourceArn'], 'TagKeys' => ['shape' => 'TagKeyList']]], 'UntagResourceResponse' => ['type' => 'structure', 'members' => []], 'UpdateIPSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'Addresses', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'Addresses' => ['shape' => 'IPAddresses'], 'LockToken' => ['shape' => 'LockToken']]], 'UpdateIPSetResponse' => ['type' => 'structure', 'members' => ['NextLockToken' => ['shape' => 'LockToken']]], 'UpdateRegexPatternSetRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'RegularExpressionList', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'RegularExpressionList' => ['shape' => 'RegularExpressionList'], 'LockToken' => ['shape' => 'LockToken']]], 'UpdateRegexPatternSetResponse' => ['type' => 'structure', 'members' => ['NextLockToken' => ['shape' => 'LockToken']]], 'UpdateRuleGroupRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'VisibilityConfig', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'Rules' => ['shape' => 'Rules'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig'], 'LockToken' => ['shape' => 'LockToken']]], 'UpdateRuleGroupResponse' => ['type' => 'structure', 'members' => ['NextLockToken' => ['shape' => 'LockToken']]], 'UpdateWebACLRequest' => ['type' => 'structure', 'required' => ['Name', 'Scope', 'Id', 'DefaultAction', 'VisibilityConfig', 'LockToken'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Scope' => ['shape' => 'Scope'], 'Id' => ['shape' => 'EntityId'], 'DefaultAction' => ['shape' => 'DefaultAction'], 'Description' => ['shape' => 'EntityDescription'], 'Rules' => ['shape' => 'Rules'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig'], 'LockToken' => ['shape' => 'LockToken']]], 'UpdateWebACLResponse' => ['type' => 'structure', 'members' => ['NextLockToken' => ['shape' => 'LockToken']]], 'UriPath' => ['type' => 'structure', 'members' => []], 'VendorName' => ['type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '.*\\S.*'], 'VisibilityConfig' => ['type' => 'structure', 'required' => ['SampledRequestsEnabled', 'CloudWatchMetricsEnabled', 'MetricName'], 'members' => ['SampledRequestsEnabled' => ['shape' => 'Boolean'], 'CloudWatchMetricsEnabled' => ['shape' => 'Boolean'], 'MetricName' => ['shape' => 'MetricName']]], 'WAFAssociatedItemException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFDuplicateItemException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFInternalErrorException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true, 'fault' => \true], 'WAFInvalidParameterException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage'], 'Field' => ['shape' => 'ParameterExceptionField'], 'Parameter' => ['shape' => 'ParameterExceptionParameter'], 'Reason' => ['shape' => 'ErrorReason']], 'exception' => \true], 'WAFInvalidResourceException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFLimitsExceededException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFNonexistentItemException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFOptimisticLockException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFServiceLinkedRoleErrorException' => ['type' => 'structure', 'members' => ['message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFTagOperationException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WAFTagOperationInternalErrorException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true, 'fault' => \true], 'WAFUnavailableEntityException' => ['type' => 'structure', 'members' => ['Message' => ['shape' => 'ErrorMessage']], 'exception' => \true], 'WebACL' => ['type' => 'structure', 'required' => ['Name', 'Id', 'ARN', 'DefaultAction', 'VisibilityConfig'], 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'ARN' => ['shape' => 'ResourceArn'], 'DefaultAction' => ['shape' => 'DefaultAction'], 'Description' => ['shape' => 'EntityDescription'], 'Rules' => ['shape' => 'Rules'], 'VisibilityConfig' => ['shape' => 'VisibilityConfig'], 'Capacity' => ['shape' => 'ConsumedCapacity']]], 'WebACLSummaries' => ['type' => 'list', 'member' => ['shape' => 'WebACLSummary']], 'WebACLSummary' => ['type' => 'structure', 'members' => ['Name' => ['shape' => 'EntityName'], 'Id' => ['shape' => 'EntityId'], 'Description' => ['shape' => 'EntityDescription'], 'LockToken' => ['shape' => 'LockToken'], 'ARN' => ['shape' => 'ResourceArn']]], 'XssMatchStatement' => ['type' => 'structure', 'required' => ['FieldToMatch', 'TextTransformations'], 'members' => ['FieldToMatch' => ['shape' => 'FieldToMatch'], 'TextTransformations' => ['shape' => 'TextTransformations']]]]];
