jQuery(function ($) {

    function Archivarius(options) {
        var obj = this;
        $.extend(obj, options);
    }

    Archivarius.prototype = {
        archiving: function (staff_id, archiving) {
            var $archiveButton = $('.bookly-js-staff-archive', this.containers.staff),
                ladda = Ladda.create($archiveButton[0]),
                self  = this
            ;
            if (archiving != 'verify') {
                ladda.start();
            }
            $.ajax({
                url : ajaxurl,
                type: 'POST',
                data: {
                    action    : 'bookly_pro_archiving_staff',
                    csrf_token: self.csrfToken,
                    staff_id  : staff_id,
                    archiving : archiving
                },
                dataType: 'json',
                success : function (response) {
                    if (response.success) {
                        // Click on button 'Archive' and staff without affecting appointments
                        if (archiving === 'verify-and-confirm') {
                            if (confirm(self.l10n.areYouSure)) {
                                self.archiving(staff_id, 'force');
                            }
                        } else if (archiving === 'force') {
                            self.confirmation.modal('hide');
                            self.containers.staff.modal('hide');
                            booklyAlert({success: [self.l10n.saved]});
                            $('#staff-list').DataTable().ajax.reload();
                        } else if (archiving != 'verify') {
                            $('[name=visibility][value=archive]', self.containers.staff).prop('checked', true);
                        }
                        self.confirmation.modal('hide');
                    } else {
                        self.confirmation.modal({backdrop: 'static', keyboard: false});
                        self.confirmation.find('.bookly-js-staff-archive').toggle(archiving !== 'verify');
                        self.confirmation.find('.btn-success').toggle(archiving === 'verify');
                        self.confirmation.find('.bookly-js-edit').off().on('click', function () {
                            ladda = Ladda.create(this);
                            ladda.start();
                            window.location.href = response.data.filter_url;
                        }).show();
                    }
                    ladda.stop();
                    Ladda.create($('.bookly-js-staff-archive', self.confirmation)[0]).stop();
                }
            });
        },
        getStaffId: function () {
            return $('[name=id]', this.containers.staff).val();
        },
        init: function () {
            var self = this;
            this.containers.staff
                .on('click', '.bookly-js-staff-archive', function (e) {
                    self.archiving(self.getStaffId(), 'verify-and-confirm');
                })
                .on('click', '#bookly-details-save', function (e) {
                    e.preventDefault();
                    var archived = $('[name=visibility]:checked').val() == 'archive';
                })
                .on('change', '[name=visibility]', function () {
                    if (this.value == 'archive') {
                        self.archiving(self.getStaffId(), 'verify');
                    }
                });

            this.confirmation
                .on('click', '.bookly-js-staff-archive', function(){
                    Ladda.create(this).start();
                    self.archiving(self.getStaffId(), 'force');
                })
                .on('click', '.bookly-js-close', function () {
                    // Check if clicked button Cancel when changed staff value visibility to 'archive'
                    if (self.confirmation.find('.btn-success').css('display') != 'none') {
                        // Reset visibility value to previous.
                        $("[name=visibility][value='" + $('#bookly-visibility', self.containers.staff).data('default') + "']").prop("checked", true);
                    }
                })
                .on('hidden.bs.modal', function () {
                    jQuery('body').addClass('modal-open');
                });;
        }
    };

    var archTool = new Archivarius({
        containers: {
            staff        : $('#bookly-staff-edit-modal'),
            categories   : $('#bookly-staff-categories'),
            counterArch  : $('#bookly-staff-archived-count'),
            counterStaff : $('#bookly-staff-count'),
        },
        csrfToken : BooklyL10nStaffArchive.csrfToken,
        confirmation: $('#bookly-archiving-confirmation'),
        l10n: {
            areYouSure: BooklyL10nStaffArchive.areYouSure,
            saved     : BooklyL10nStaffArchive.saved,
        }
    });

    archTool.init();
});